/// Trial mode controls whether SAMPLE watermark is drawn.
private var trialModeOverride = false
private var trialModeValue = true

/// Sets whether trial mode is active (true = show SAMPLE watermark).
public func setTrialMode(_ isTrial: Bool) {
    trialModeOverride = true
    trialModeValue = isTrial
}

/// Returns true if trial mode is active.
public func isTrialMode() -> Bool {
    if trialModeOverride {
        return trialModeValue
    }
    return true
}

/// Returns the trial watermark text.
func getTrialText() -> String {
    String(bytes: [0x53, 0x41, 0x4D, 0x50, 0x4C, 0x45], encoding: .ascii) ?? "SAMPLE"
}
