/// RGBA color with red, green, blue, and alpha components (0-255).
public struct RGBA: Equatable, Sendable {
    public var r: UInt8
    public var g: UInt8
    public var b: UInt8
    public var a: UInt8

    public init(_ r: UInt8, _ g: UInt8, _ b: UInt8, _ a: UInt8 = 255) {
        self.r = r
        self.g = g
        self.b = b
        self.a = a
    }

    public static let black = RGBA(0, 0, 0, 255)
    public static let white = RGBA(255, 255, 255, 255)
    public static let red   = RGBA(255, 0, 0, 255)
}

/// Returns an SVG rgb() color string.
func colorToRGB(_ c: RGBA) -> String {
    "rgb(\(c.r),\(c.g),\(c.b))"
}
