import Foundation

/// Converts a bit pattern to run-length encoded bar/space widths.
/// Processes from MSB. Consecutive same-value bits are grouped.
/// Returns alternating widths (first value type depends on MSB: 1=bar first, 0=space first).
func bitsToRunlength(pattern: Int, numBits: Int) -> [Int] {
    var result = [Int]()
    let maskStart = 1 << (numBits - 1)
    var j = 0
    while j < numBits {
        let bit = (pattern & (maskStart >> j)) != 0
        var count = 1
        j += 1
        while j < numBits {
            let nextBit = (pattern & (maskStart >> j)) != 0
            if nextBit == bit {
                count += 1
                j += 1
            } else {
                break
            }
        }
        result.append(count)
    }
    return result
}
