import Foundation

/// Errors that can occur during barcode generation.
public enum BarcodeError: Error, LocalizedError {
    case emptyString
    case invalidCharacter(symbology: String, character: Character)
    case invalidInput(String)
    case encodingFailed(String)
    case renderFailed(String)
    case wrongOutputMode(String)

    public var errorDescription: String? {
        switch self {
        case .emptyString:
            return "empty string"
        case .invalidCharacter(let sym, let ch):
            return "invalid character in \(sym): \(ch)"
        case .invalidInput(let msg):
            return msg
        case .encodingFailed(let msg):
            return msg
        case .renderFailed(let msg):
            return msg
        case .wrongOutputMode(let msg):
            return msg
        }
    }
}
