use std::sync::atomic::{AtomicBool, Ordering};

static TRIAL_MODE_OVERRIDE: AtomicBool = AtomicBool::new(false);
static TRIAL_MODE_VALUE: AtomicBool = AtomicBool::new(true);

/// Sets whether trial mode is active (true = show SAMPLE watermark).
pub fn set_trial_mode(is_trial: bool) {
    TRIAL_MODE_OVERRIDE.store(true, Ordering::Relaxed);
    TRIAL_MODE_VALUE.store(is_trial, Ordering::Relaxed);
}

/// Returns true if trial mode is active.
pub fn is_trial_mode() -> bool {
    if TRIAL_MODE_OVERRIDE.load(Ordering::Relaxed) {
        TRIAL_MODE_VALUE.load(Ordering::Relaxed)
    } else {
        true
    }
}

/// Returns the trial watermark text.
pub(crate) fn get_trial_text() -> &'static str {
    "SAMPLE"
}
