/// Errors returned by barcode operations.
#[derive(thiserror::Error, Debug)]
pub enum BarcodeError {
    #[error("Invalid data: {0}")]
    InvalidData(String),

    #[error("Empty code")]
    EmptyCode,

    #[error("Invalid character '{ch}' in {symbology}")]
    InvalidCharacter { ch: char, symbology: String },

    #[error("Encoding error: {0}")]
    EncodingError(String),

    #[error("Image error: {0}")]
    ImageError(String),

    #[error("Format error: {0}")]
    FormatError(String),

    #[error("Render error: {0}")]
    RenderError(String),
}

pub type Result<T> = std::result::Result<T, BarcodeError>;
