/// Converts a bit pattern to run-length encoded bar/space widths.
/// Processes from MSB. Consecutive same-value bits are grouped.
pub fn bits_to_runlength(pattern: i32, num_bits: i32) -> Vec<i32> {
    let mut result = Vec::new();
    let mask_start = 1 << (num_bits - 1);
    let mut j = 0;
    while j < num_bits {
        let bit = (pattern & (mask_start >> j)) != 0;
        let mut count = 1;
        j += 1;
        while j < num_bits {
            let next_bit = (pattern & (mask_start >> j)) != 0;
            if next_bit == bit {
                count += 1;
                j += 1;
            } else {
                break;
            }
        }
        result.push(count);
    }
    result
}

#[cfg(test)]
mod tests {
    use super::*;

    #[test]
    fn test_bits_to_runlength() {
        // 0x0d = 0001101 (7 bits) -> should give [3, 2, 1, 1]
        let result = bits_to_runlength(0x0d, 7);
        assert_eq!(result, vec![3, 2, 1, 1]);
    }
}
