use crate::base::BarcodeBase;

/// Base for 2D barcode symbologies (QR, DataMatrix, PDF417).
pub struct BarcodeBase2D {
    pub base: BarcodeBase,
    pub(crate) string_encoding: String,
}

impl BarcodeBase2D {
    pub fn new(output_format: &str) -> Self {
        Self {
            base: BarcodeBase::new(output_format),
            string_encoding: "utf-8".to_string(),
        }
    }

    pub fn string_encoding(&self) -> &str {
        &self.string_encoding
    }

    pub fn set_string_encoding(&mut self, encoding: &str) {
        self.string_encoding = encoding.to_string();
    }
}
