# frozen_string_literal: true

module BarcodePao
  @trial_mode_override = false
  @trial_mode_value = true

  def self.set_trial_mode(is_trial)
    @trial_mode_override = true
    @trial_mode_value = is_trial
  end

  def self.trial_mode?
    return @trial_mode_value if @trial_mode_override
    true
  end

  def self.trial_text
    [0x53, 0x41, 0x4D, 0x50, 0x4C, 0x45].pack("C*")
  end
end
