# frozen_string_literal: true

module BarcodePao
  module BitsUtil
    # Convert a bit pattern to run-length encoded bar/space widths.
    # Processes from MSB. Consecutive same-value bits are grouped.
    def self.bits_to_runlength(pattern, num_bits)
      result = []
      mask_start = 1 << (num_bits - 1)
      j = 0
      while j < num_bits
        bit = (pattern & (mask_start >> j)) != 0
        count = 1
        j += 1
        while j < num_bits
          next_bit = (pattern & (mask_start >> j)) != 0
          if next_bit == bit
            count += 1
            j += 1
          else
            break
          end
        end
        result << count
      end
      result
    end
  end
end
