# frozen_string_literal: true

require_relative "lib/barcode_pao/version"

Gem::Specification.new do |spec|
  spec.name          = "barcode_pao"
  spec.version       = BarcodePao::VERSION
  spec.authors       = ["Pao@Office"]
  spec.email         = ["info@pao.ac"]

  spec.summary       = "Pure Ruby barcode generation library - 18 barcode types"
  spec.description   = "Barcode.Ruby is a Pure Ruby barcode generation library supporting " \
                        "18 barcode types: Code39, Code93, Code128, GS1-128, NW-7, ITF, " \
                        "Matrix 2of5, NEC 2of5, JAN-8, JAN-13, UPC-A, UPC-E, " \
                        "GS1 DataBar (Standard/Limited/Expanded), QR Code, DataMatrix, " \
                        "PDF417, and Japan Post Customer Barcode. " \
                        "Output formats: PNG, SVG."
  spec.homepage      = "https://www.pao.ac/barcode.ruby/"
  spec.license       = "Commercial"

  spec.required_ruby_version = ">= 3.0.0"

  spec.files         = Dir["lib/**/*.rb", "Roboto-Regular.ttf", "LICENSE", "README.md"]
  spec.require_paths = ["lib"]

  spec.add_dependency "chunky_png", "~> 1.4"
  spec.add_dependency "ttfunk", "~> 1.8"
end
