# frozen_string_literal: true

require_relative "lib/barcode_pao_wasm/version"

Gem::Specification.new do |spec|
  spec.name          = "barcode_pao_wasm"
  spec.version       = BarcodePaoWasm::VERSION
  spec.authors       = ["Pao"]
  spec.email         = ["info@pao.ac"]

  spec.summary       = "Cross-platform barcode generation library for Ruby (WASM version)"
  spec.description   = "Cross-platform barcode generation library using WebAssembly, " \
                        "supporting 18 barcode types: Code39, Code93, Code128, GS1-128, NW-7, ITF, " \
                        "Matrix 2of5, NEC 2of5, JAN-8, JAN-13, UPC-A, UPC-E, " \
                        "GS1 DataBar (Standard/Limited/Expanded), QR Code, DataMatrix, " \
                        "PDF417, and Japan Post Customer Barcode. " \
                        "Output formats: PNG, JPEG, SVG. Requires Node.js."
  spec.homepage      = "https://github.com/pao-ac/barcode-pao-wasm-ruby"
  spec.license       = "MIT"

  spec.required_ruby_version = ">= 2.7.0"

  spec.files         = Dir["lib/**/*.rb", "wasm/*", "LICENSE", "README.md"]
  spec.require_paths = ["lib"]

  spec.metadata = {
    "homepage_uri" => spec.homepage,
    "source_code_uri" => spec.homepage,
  }
end
