package barcode

import (
	"strings"
	"testing"
)

func TestUPCEEncode7Digits(t *testing.T) {
	u := NewUPCE(FormatSVG)
	pattern, err := u.Encode("0123456")
	if err != nil {
		t.Fatalf("Encode failed: %v", err)
	}
	if len(pattern) == 0 {
		t.Fatal("pattern is empty")
	}
}

func TestUPCEEncode6Digits(t *testing.T) {
	u := NewUPCE(FormatSVG)
	pattern, err := u.Encode("123456")
	if err != nil {
		t.Fatalf("Encode failed: %v", err)
	}
	if len(pattern) == 0 {
		t.Fatal("pattern is empty")
	}
}

func TestUPCEDrawSVG(t *testing.T) {
	u := NewUPCE(FormatSVG)
	err := u.Draw("0123456", 200, 100)
	if err != nil {
		t.Fatalf("Draw failed: %v", err)
	}
	svg, err := u.GetSVG()
	if err != nil {
		t.Fatalf("GetSVG failed: %v", err)
	}
	if !strings.Contains(svg, "<svg") {
		t.Error("SVG missing <svg tag")
	}
}

func TestUPCEDrawPNG(t *testing.T) {
	u := NewUPCE(FormatPNG)
	err := u.Draw("0123456", 200, 100)
	if err != nil {
		t.Fatalf("Draw failed: %v", err)
	}
	data := u.GetImageMemory()
	if len(data) == 0 {
		t.Fatal("PNG output is empty")
	}
}

func TestUPCECheckDigit(t *testing.T) {
	cd := CalculateCheckDigitUPCE("0123456")
	if cd == "" {
		t.Error("check digit should not be empty")
	}
}

func TestExpandToUPCA(t *testing.T) {
	expanded := expandToUPCA("0123456")
	if expanded == "" {
		t.Error("expansion should not be empty")
	}
}
