package barcode

import (
	"strings"
	"testing"
)

func TestUPCAEncode11Digits(t *testing.T) {
	u := NewUPCA(FormatSVG)
	pattern, err := u.Encode("01234567890")
	if err != nil {
		t.Fatalf("Encode failed: %v", err)
	}
	if len(pattern) == 0 {
		t.Fatal("pattern is empty")
	}
}

func TestUPCAEncode12Digits(t *testing.T) {
	u := NewUPCA(FormatSVG)
	cd := CalculateCheckDigitUPCA("01234567890")
	code := "01234567890" + cd
	pattern, err := u.Encode(code)
	if err != nil {
		t.Fatalf("Encode failed: %v", err)
	}
	if len(pattern) == 0 {
		t.Fatal("pattern is empty")
	}
}

func TestUPCADrawSVG(t *testing.T) {
	u := NewUPCA(FormatSVG)
	err := u.Draw("01234567890", 300, 100)
	if err != nil {
		t.Fatalf("Draw failed: %v", err)
	}
	svg, err := u.GetSVG()
	if err != nil {
		t.Fatalf("GetSVG failed: %v", err)
	}
	if !strings.Contains(svg, "<svg") {
		t.Error("SVG missing <svg tag")
	}
}

func TestUPCADrawPNG(t *testing.T) {
	u := NewUPCA(FormatPNG)
	err := u.Draw("01234567890", 300, 100)
	if err != nil {
		t.Fatalf("Draw failed: %v", err)
	}
	data := u.GetImageMemory()
	if len(data) == 0 {
		t.Fatal("PNG output is empty")
	}
}

func TestUPCACheckDigit(t *testing.T) {
	cd := CalculateCheckDigitUPCA("01234567890")
	if cd == "" {
		t.Error("check digit should not be empty")
	}
}
