package barcode

import "testing"

func TestGetCombinations(t *testing.T) {
	// nCr(5,2) = 10
	if c := getCombinations(5, 2); c != 10 {
		t.Errorf("expected 10, got %d", c)
	}
	// nCr(10,3) = 120
	if c := getCombinations(10, 3); c != 120 {
		t.Errorf("expected 120, got %d", c)
	}
}

func TestGetWidths(t *testing.T) {
	w := getWidths(0, 12, 4, 8, 1)
	total := 0
	for _, v := range w {
		total += v
	}
	if total != 12 {
		t.Errorf("expected total 12, got %d", total)
	}
	if len(w) != 4 {
		t.Errorf("expected 4 elements, got %d", len(w))
	}
}

func TestCalculateGTINCheckDigit(t *testing.T) {
	// Known: 0000000000000 -> check digit 0
	cd := calculateGTINCheckDigit("0000000000000")
	if cd != 0 {
		t.Errorf("expected 0, got %d", cd)
	}
}

func TestBin2pat(t *testing.T) {
	// "000111" -> "33" (3 zeros, 3 ones)
	p := bin2pat("000111")
	if p != "33" {
		t.Errorf("expected '33', got '%s'", p)
	}
	// "0011110" -> "243" (2 zeros, 4 ones, 1 zero)
	p = bin2pat("0011110")
	if p != "241" {
		t.Errorf("expected '241', got '%s'", p)
	}
}

func TestPadLeft(t *testing.T) {
	if s := padLeft("123", 7); s != "0000123" {
		t.Errorf("expected '0000123', got '%s'", s)
	}
}

func TestParseInt64(t *testing.T) {
	if v := parseInt64("12345"); v != 12345 {
		t.Errorf("expected 12345, got %d", v)
	}
}
