package barcode

// trialMode controls whether SAMPLE watermark is drawn.
var (
	trialModeOverride bool
	trialModeValue    = true
)

// SetTrialMode sets whether trial mode is active (true = show SAMPLE watermark).
func SetTrialMode(isTrial bool) {
	trialModeOverride = true
	trialModeValue = isTrial
}

// IsTrialMode returns true if trial mode is active.
func IsTrialMode() bool {
	if trialModeOverride {
		return trialModeValue
	}
	return true
}

// getTrialText returns the trial watermark text.
func getTrialText() string {
	return string([]byte{0x53, 0x41, 0x4D, 0x50, 0x4C, 0x45})
}

// GetTrialText returns the trial watermark text for external renderers.
func GetTrialText() string {
	return getTrialText()
}
