package barcode

import (
	"strings"
	"testing"
)

func TestNW7EncodeWithStartStop(t *testing.T) {
	n := NewNW7(FormatSVG)
	pattern, err := n.Encode("A12345B")
	if err != nil {
		t.Fatalf("Encode failed: %v", err)
	}
	if len(pattern) == 0 {
		t.Fatal("pattern is empty")
	}
}

func TestNW7EncodeAutoStartStop(t *testing.T) {
	n := NewNW7(FormatSVG)
	// No start/stop → auto-wrap with C...C
	pattern, err := n.Encode("12345")
	if err != nil {
		t.Fatalf("Encode failed: %v", err)
	}
	// C + 5 digits + C = 7 chars; each 7 bars + 6 gaps of 2
	// 7*7 + 6*2 = 61
	if len(pattern) == 0 {
		t.Fatal("pattern is empty")
	}
}

func TestNW7InvalidStartStop(t *testing.T) {
	n := NewNW7(FormatSVG)
	// Only start, no stop
	_, err := n.Encode("A1234")
	if err == nil {
		t.Fatal("expected error for invalid start/stop combination")
	}
}

func TestNW7DrawSVG(t *testing.T) {
	n := NewNW7(FormatSVG)
	err := n.Draw("A12345B", 400, 100)
	if err != nil {
		t.Fatalf("Draw failed: %v", err)
	}
	svg, err := n.GetSVG()
	if err != nil {
		t.Fatalf("GetSVG failed: %v", err)
	}
	if !strings.Contains(svg, "<svg") {
		t.Error("SVG output missing <svg tag")
	}
}
