package barcode

import (
	"strings"
	"testing"
)

func TestNEC2of5Encode(t *testing.T) {
	n := NewNEC2of5(FormatSVG)
	pattern, err := n.Encode("12345")
	if err != nil {
		t.Fatalf("Encode failed: %v", err)
	}
	if len(pattern) == 0 {
		t.Fatal("pattern is empty")
	}
}

func TestNEC2of5NonNumeric(t *testing.T) {
	n := NewNEC2of5(FormatSVG)
	_, err := n.Encode("12A")
	if err == nil {
		t.Fatal("expected error for non-numeric input")
	}
}

func TestNEC2of5DrawSVG(t *testing.T) {
	n := NewNEC2of5(FormatSVG)
	err := n.Draw("12345", 400, 100)
	if err != nil {
		t.Fatalf("Draw failed: %v", err)
	}
	svg, err := n.GetSVG()
	if err != nil {
		t.Fatalf("GetSVG failed: %v", err)
	}
	if !strings.Contains(svg, "<svg") {
		t.Error("SVG output missing <svg tag")
	}
}

func TestNEC2of5DrawPNG(t *testing.T) {
	n := NewNEC2of5(FormatPNG)
	err := n.Draw("12345", 400, 100)
	if err != nil {
		t.Fatalf("Draw failed: %v", err)
	}
	data := n.GetImageMemory()
	if len(data) == 0 {
		t.Fatal("PNG output is empty")
	}
}
