package barcode

import (
	"strings"
	"testing"
)

func TestMatrix2of5Encode(t *testing.T) {
	m := NewMatrix2of5(FormatSVG)
	pattern, err := m.Encode("12345")
	if err != nil {
		t.Fatalf("Encode failed: %v", err)
	}
	if len(pattern) == 0 {
		t.Fatal("pattern is empty")
	}
}

func TestMatrix2of5NonNumeric(t *testing.T) {
	m := NewMatrix2of5(FormatSVG)
	_, err := m.Encode("12A")
	if err == nil {
		t.Fatal("expected error for non-numeric input")
	}
}

func TestMatrix2of5DrawSVG(t *testing.T) {
	m := NewMatrix2of5(FormatSVG)
	err := m.Draw("12345", 400, 100)
	if err != nil {
		t.Fatalf("Draw failed: %v", err)
	}
	svg, err := m.GetSVG()
	if err != nil {
		t.Fatalf("GetSVG failed: %v", err)
	}
	if !strings.Contains(svg, "<svg") {
		t.Error("SVG output missing <svg tag")
	}
}
