package barcode

import (
	"strings"
	"testing"
)

func TestJAN13Encode12Digits(t *testing.T) {
	j := NewJAN13(FormatSVG)
	pattern, err := j.Encode("490123456789")
	if err != nil {
		t.Fatalf("Encode failed: %v", err)
	}
	if len(pattern) == 0 {
		t.Fatal("pattern is empty")
	}
}

func TestJAN13Encode13Digits(t *testing.T) {
	j := NewJAN13(FormatSVG)
	cd := CalculateCheckDigitJAN13("490123456789")
	code := "490123456789" + cd
	pattern, err := j.Encode(code)
	if err != nil {
		t.Fatalf("Encode failed: %v", err)
	}
	if len(pattern) == 0 {
		t.Fatal("pattern is empty")
	}
}

func TestJAN13InvalidCheckDigit(t *testing.T) {
	j := NewJAN13(FormatSVG)
	_, err := j.Encode("4901234567890") // likely wrong check digit
	// This may or may not error depending on actual check digit
	_ = err
}

func TestJAN13DrawSVG(t *testing.T) {
	j := NewJAN13(FormatSVG)
	err := j.Draw("490123456789", 300, 100)
	if err != nil {
		t.Fatalf("Draw failed: %v", err)
	}
	svg, err := j.GetSVG()
	if err != nil {
		t.Fatalf("GetSVG failed: %v", err)
	}
	if !strings.Contains(svg, "<svg") {
		t.Error("SVG missing <svg tag")
	}
	// Should contain prefix digit text
	if !strings.Contains(svg, "<text") {
		t.Error("SVG missing text elements")
	}
}

func TestJAN13DrawPNG(t *testing.T) {
	j := NewJAN13(FormatPNG)
	err := j.Draw("490123456789", 300, 100)
	if err != nil {
		t.Fatalf("Draw failed: %v", err)
	}
	data := j.GetImageMemory()
	if len(data) == 0 {
		t.Fatal("PNG output is empty")
	}
}

func TestJAN13CheckDigit(t *testing.T) {
	cd := CalculateCheckDigitJAN13("490123456789")
	// Known check digit for 490123456789
	if cd == "" {
		t.Error("check digit should not be empty")
	}
}
