package barcode

import (
	"strings"
	"testing"
)

func TestGS1128EncodeBasic(t *testing.T) {
	g := NewGS1128(FormatSVG)
	pattern, err := g.Encode("{FNC1}0104912345123459")
	if err != nil {
		t.Fatalf("Encode failed: %v", err)
	}
	if len(pattern) == 0 {
		t.Fatal("pattern is empty")
	}
}

func TestGS1128EncodeWithAI(t *testing.T) {
	g := NewGS1128(FormatSVG)
	pattern, err := g.Encode("{FNC1}{AI}0104912345123459{FNC1}{AI}10ABC123")
	if err != nil {
		t.Fatalf("Encode failed: %v", err)
	}
	if len(pattern) == 0 {
		t.Fatal("pattern is empty")
	}
}

func TestGS1128Empty(t *testing.T) {
	g := NewGS1128(FormatSVG)
	_, err := g.Encode("")
	if err == nil {
		t.Fatal("expected error for empty string")
	}
}

func TestGS1128DrawSVG(t *testing.T) {
	g := NewGS1128(FormatSVG)
	err := g.Draw("{FNC1}0104912345123459", 500, 100)
	if err != nil {
		t.Fatalf("Draw failed: %v", err)
	}
	svg, err := g.GetSVG()
	if err != nil {
		t.Fatalf("GetSVG failed: %v", err)
	}
	if !strings.Contains(svg, "<svg") {
		t.Error("SVG missing <svg tag")
	}
}

func TestGS1128DrawPNG(t *testing.T) {
	g := NewGS1128(FormatPNG)
	err := g.Draw("{FNC1}0104912345123459", 500, 100)
	if err != nil {
		t.Fatalf("Draw failed: %v", err)
	}
	data := g.GetImageMemory()
	if len(data) == 0 {
		t.Fatal("PNG output is empty")
	}
}

func TestCalcCheckDigitMod10W3(t *testing.T) {
	// Known test case
	cd := CalcCheckDigitMod10W3("9100000000000000000000000000000012345600100000")
	if cd < 0 || cd > 9 {
		t.Errorf("check digit %d out of range", cd)
	}
}
