package barcode

import (
	"strings"
	"testing"
)

func TestCode93Encode(t *testing.T) {
	c := NewCode93(FormatSVG)
	pattern, err := c.Encode("CODE93")
	if err != nil {
		t.Fatalf("Encode failed: %v", err)
	}
	if len(pattern) == 0 {
		t.Fatal("pattern is empty")
	}
	// Start(6) + 6chars*6 + checkC(6) + checkK(6) + Stop(7) = 6+36+6+6+7 = 61
	if len(pattern) != 61 {
		t.Errorf("expected 61 elements, got %d", len(pattern))
	}
}

func TestCode93Invalid(t *testing.T) {
	c := NewCode93(FormatSVG)
	_, err := c.Encode("abc@")
	if err == nil {
		t.Fatal("expected error for invalid character")
	}
}

func TestCode93DrawSVG(t *testing.T) {
	c := NewCode93(FormatSVG)
	err := c.Draw("CODE93", 400, 100)
	if err != nil {
		t.Fatalf("Draw failed: %v", err)
	}
	svg, err := c.GetSVG()
	if err != nil {
		t.Fatalf("GetSVG failed: %v", err)
	}
	if !strings.Contains(svg, "<svg") {
		t.Error("SVG output missing <svg tag")
	}
}

func TestCode93DrawPNG(t *testing.T) {
	c := NewCode93(FormatPNG)
	err := c.Draw("CODE93", 400, 100)
	if err != nil {
		t.Fatalf("Draw failed: %v", err)
	}
	data := c.GetImageMemory()
	if len(data) == 0 {
		t.Fatal("PNG output is empty")
	}
}
