package barcode

import (
	"strings"
	"testing"
)

func TestCode128EncodeAuto(t *testing.T) {
	c := NewCode128(FormatSVG)
	pattern, err := c.Encode("Hello123")
	if err != nil {
		t.Fatalf("Encode failed: %v", err)
	}
	if len(pattern) == 0 {
		t.Fatal("pattern is empty")
	}
}

func TestCode128EncodeCodeB(t *testing.T) {
	c := NewCode128(FormatSVG)
	c.CodeMode = Code128CodeB
	pattern, err := c.Encode("Hello")
	if err != nil {
		t.Fatalf("Encode failed: %v", err)
	}
	if len(pattern) == 0 {
		t.Fatal("pattern is empty")
	}
}

func TestCode128EncodeCodeC(t *testing.T) {
	c := NewCode128(FormatSVG)
	c.CodeMode = Code128CodeC
	pattern, err := c.Encode("123456")
	if err != nil {
		t.Fatalf("Encode failed: %v", err)
	}
	if len(pattern) == 0 {
		t.Fatal("pattern is empty")
	}
}

func TestCode128EncodeCodeCOddDigits(t *testing.T) {
	c := NewCode128(FormatSVG)
	c.CodeMode = Code128CodeC
	_, err := c.Encode("12345")
	if err == nil {
		t.Fatal("expected error for odd digit count in CODE_C")
	}
}

func TestCode128Empty(t *testing.T) {
	c := NewCode128(FormatSVG)
	_, err := c.Encode("")
	if err == nil {
		t.Fatal("expected error for empty string")
	}
}

func TestCode128DrawSVG(t *testing.T) {
	c := NewCode128(FormatSVG)
	err := c.Draw("Code128Test", 400, 100)
	if err != nil {
		t.Fatalf("Draw failed: %v", err)
	}
	svg, err := c.GetSVG()
	if err != nil {
		t.Fatalf("GetSVG failed: %v", err)
	}
	if !strings.Contains(svg, "<svg") {
		t.Error("SVG output missing <svg tag")
	}
}

func TestCode128DrawPNG(t *testing.T) {
	c := NewCode128(FormatPNG)
	err := c.Draw("Code128Test", 400, 100)
	if err != nil {
		t.Fatalf("Draw failed: %v", err)
	}
	data := c.GetImageMemory()
	if len(data) == 0 {
		t.Fatal("PNG output is empty")
	}
}

func TestCode128NumericOptimization(t *testing.T) {
	c := NewCode128(FormatSVG)
	// Pure numeric should use CODE-C for optimal encoding
	pattern, err := c.Encode("1234567890")
	if err != nil {
		t.Fatalf("Encode failed: %v", err)
	}
	if len(pattern) == 0 {
		t.Fatal("pattern is empty")
	}
}
