package barcode

// bitsToRunlength converts a bit pattern to run-length encoded bar/space widths.
// Processes from MSB. Consecutive same-value bits are grouped.
// Returns alternating widths (first value type depends on MSB: 1=bar first, 0=space first).
func bitsToRunlength(pattern int, numBits int) []int {
	var result []int
	maskStart := 1 << (numBits - 1)
	j := 0
	for j < numBits {
		bit := (pattern & (maskStart >> j)) != 0
		count := 1
		j++
		for j < numBits {
			nextBit := (pattern & (maskStart >> j)) != 0
			if nextBit == bit {
				count++
				j++
			} else {
				break
			}
		}
		result = append(result, count)
	}
	return result
}
