package barcode

// BarcodeBase2D is the base for 2D barcode symbologies (QR, DataMatrix, PDF417).
type BarcodeBase2D struct {
	BarcodeBase
	stringEncoding string
}

// InitBase2D initialises BarcodeBase2D with defaults.
func (b *BarcodeBase2D) InitBase2D(outputFormat string) {
	b.InitBase(outputFormat)
	b.stringEncoding = "utf-8"
}

// GetStringEncoding returns the current string encoding.
func (b *BarcodeBase2D) GetStringEncoding() string { return b.stringEncoding }

// SetStringEncoding sets the string encoding ("utf-8" or "shift-jis").
func (b *BarcodeBase2D) SetStringEncoding(encoding string) {
	b.stringEncoding = encoding
}
