// Package barcode provides a pure Go barcode generation library.
//
// Supported symbologies:
//
// 1D: Code39, Code93, Code128, GS1-128, NW-7, ITF, Matrix2of5, NEC2of5,
// JAN-8, JAN-13, UPC-A, UPC-E, GS1 DataBar (Standard/Limited/Expanded)
//
// 2D: QR Code, DataMatrix, PDF417
//
// Special: Japan Post Customer Barcode (Yubin Customer)
//
// Output formats: PNG, JPEG, SVG
package barcode

// Output format constants.
const (
	FormatPNG  = "png"
	FormatJPEG = "jpeg"
	FormatSVG  = "svg"
)
